library(alluvial)
cccol <- rev(c("red","#16557A","#15A08C","#1E7CAF"))
names(cccol) <- c("Non-marked","H3K4me2","H3K4me3","H3K4me2&H3K4me3")
naive <- read.table("naive_HM_class_change.txt")
colnames(naive) <- c("hiF", "he6", "n24", "niPS", "Freq")

pdf("naive.pdf",width=9,height=7)
st2 <- aggregate(Freq ~ hiF + he6 + n24 + niPS, data=naive, sum)
alluvial(st2[,1:4], freq=st2$Freq)
dev.off()

pdf("hiF_he6.pdf",width=2,height=7)
st2 <- aggregate(Freq ~ hiF + he6, data=naive, sum)
alluvial(st2[,1:2], freq=st2$Freq, col=cccol[st2[,2]], cex=0.5,alpha = 0.8)
dev.off()

pdf("he6_n24.pdf",width=2,height=7)
st2 <- aggregate(Freq ~ he6 + n24, data=naive, sum)
alluvial(st2[,1:2], freq=st2$Freq, col=cccol[st2[,2]], cex=0.5,alpha = 0.8)
dev.off()

pdf("n24_niPS.pdf",width=2,height=7)
st2 <- aggregate(Freq ~ n24 + niPS, data=naive, sum)
alluvial(st2[,1:2], freq=st2$Freq, col=cccol[st2[,2]], cex=0.5,alpha = 0.8)
dev.off()


primed <- read.table("primed_HM_class_change.txt")
colnames(primed) <- c("hiF", "he6", "p24", "piPS","Freq")

pdf("primed.pdf",width=9,height=7)
st2 <- aggregate(Freq ~ hiF + he6 + p24 + piPS, data=primed, sum)
alluvial(st2[,1:4], freq=st2$Freq)
dev.off()

pdf("he6_p24.pdf",width=2,height=7)
st2 <- aggregate(Freq ~ he6 + p24, data=primed, sum)
alluvial(st2[,1:2], freq=st2$Freq, col=cccol[st2[,2]], cex=0.5,alpha = 0.8)
dev.off()

pdf("p24_piPS.pdf",width=2,height=7)
st2 <- aggregate(Freq ~ p24 + piPS, data=primed, sum)
alluvial(st2[,1:2], freq=st2$Freq, col=cccol[st2[,2]], cex=0.5,alpha = 0.8)
dev.off()
